/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.lib.multipart.MultipartTE;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class MultipartBakedModel
extends AbstractDynamicBakedModel {
    public static final ModelResourceLocation MODEL = new ModelResourceLocation("mcjtylib:multipart");

    @Override
    public boolean m_7547_() {
        return false;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null) {
            return Collections.emptyList();
        }
        Map parts = (Map)extraData.getData(MultipartTE.PARTS);
        if (parts != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            RenderType layer = MinecraftForgeClient.getRenderType();
            for (Map.Entry entry : parts.entrySet()) {
                MultipartTE.Part part = (MultipartTE.Part)entry.getValue();
                BlockState blockState = part.getState();
                if (layer != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(blockState);
                try {
                    if (model instanceof MultipartBakedModel) continue;
                    quads.addAll(model.m_6840_(state, side, rand));
                }
                catch (Exception ignore) {
                    System.out.println("MultipartBakedModel.getQuads");
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean m_7541_() {
        return true;
    }

    @Override
    public boolean m_7539_() {
        return false;
    }

    @Override
    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return MultipartBakedModel.getTexture(new ResourceLocation("minecraft", "missingno"));
    }

    @Override
    @Nonnull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @Override
    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

